import os
import shutil
import sys
import urllib.parse
import xbmc
import xbmcaddon
import xbmcgui
import xbmcplugin
import xbmcvfs
import uuid
import requests

# Import other necessary modules...

__addon__ = xbmcaddon.Addon()
__temp__ = xbmcvfs.translatePath('special://temp')

addon = xbmcaddon.Addon()

BASE_URL = 'https://astreamweb.com/subtitles/subtitle.php?title='


def fetch_subtitles(title):
    url = BASE_URL + urllib.parse.quote_plus(title)

    xbmc.log(f"API URL: {url}")

    try:
        response = requests.get(url)
        response.raise_for_status()

        xbmc.log(f"API Response: {response.text}", level=xbmc.LOGDEBUG)

        subtitles_data = response.json()

        xbmc.log(f"Decoded Data: {subtitles_data}", level=xbmc.LOGDEBUG)

        return subtitles_data
    except requests.exceptions.RequestException as e:
        xbmc.log(f"Request to API failed: {e}", level=xbmc.LOGERROR)
        return None
    except json.JSONDecodeError as e:
        xbmc.log(f"Error decoding JSON: {e}", level=xbmc.LOGERROR)
        return None
    except Exception as ex:
        xbmc.log(f"An error occurred: {ex}", level=xbmc.LOGERROR)
        return None

# Other addon info...

# Define paths and setup...

# Import necessary functions and classes from OSUtilities...
def list_subtitles(title, search_results):
    xbmc.log(f"Number of Subtitles: {len(search_results)}", xbmc.LOGDEBUG)

    for subtitle in search_results:
        language = subtitle.get('language', 'Unknown Language')
        url = subtitle.get('url', '')
        title = subtitle.get('title', '')  # Correct key here
        xbmc.log(f"Subtitle: {language}, URL: {url}, Title: {title}", xbmc.LOGDEBUG)
        
        subtitle_list = download_subtitle(subtitle['IDSubtitleFile'], subtitle['ZipDownloadLink'], subtitle['SubFormat'], language, title)

        for sub in subtitle_list:
            xbmc.log(f"Adding subtitle to list: {title} - {language}", xbmc.LOGDEBUG)
            list_item = xbmcgui.ListItem(label=f"{title} - {language}")  # Include the title in the label
            xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=sub, listitem=list_item, isFolder=False)

    xbmcplugin.endOfDirectory(int(sys.argv[1]))




def manual_search(searchstring, languages, preferredlanguage):
    xbmc.log(f"Manual Search: {searchstring}, Languages: {languages}, Preferred Language: {preferredlanguage}", xbmc.LOGDEBUG)

    subtitles_data = fetch_subtitles(searchstring)

    if subtitles_data is not None and 'subtitles' in subtitles_data:
        subtitle_directory = xbmcvfs.translatePath('special://temp/subtitles')  # Move this line here

        for subtitle in subtitles_data['subtitles']:
            language = subtitle.get('language', 'Unknown Language')
            url = subtitle.get('url', '')
            title = subtitle.get('title', '')

            subtitle_content = download_subtitle(subtitle['url'], 'srt', language, title, subtitle_directory)

            if subtitle_content is not None:
                subtitle_path = os.path.join(subtitle_directory, f"{language}.srt")
                subtitle_content_str = '\n'.join(subtitle_content)
                with open(subtitle_path, 'w', encoding='utf-8') as subtitle_file:
                    subtitle_file.write(subtitle_content_str)

                list_item = xbmcgui.ListItem(label=language, label2=title)
                list_item.setSubtitles([subtitle_path])
                list_item.setProperty('IsPlayable', 'true')
                xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=url, listitem=list_item, isFolder=False)

        xbmcplugin.endOfDirectory(int(sys.argv[1]))

import traceback

# ... (other imports)

# ... (other imports)

# ... (other imports)

import zipfile

# ... (other imports)

def download_subtitle(id, url, format, language, subtitle_directory):
    subtitle_list = []
    exts = [".srt", ".sub", ".txt", ".smi", ".ssa", ".ass"]

    subtitle = os.path.join(subtitle_directory, f"{str(uuid.uuid4())}.{format}")

    return subtitle_list

    if not result:
        xbmc.log("Download Using HTTP")
        zip_file = os.path.join(subtitle_directory, "OpenSubtitles.zip")
        try:
            with urllib.request.urlopen(url) as response:
                with open(zip_file, "wb") as sub_file:
                    sub_file.write(response.read())
        except Exception as ex:
            xbmc.log(f"Failed to download subtitle using HTTP: {ex}", level=xbmc.LOGERROR)
            return subtitle_list

        xbmc.sleep(500)

        try:
            with zipfile.ZipFile(zip_file, 'r') as zip_ref:
                zip_ref.extractall(subtitle_directory)
        except Exception as ex:
            xbmc.log(f"Failed to extract subtitle zip file: {ex}", level=xbmc.LOGERROR)
            return subtitle_list

        for file in xbmcvfs.listdir(subtitle_directory)[1]:
            file_path = os.path.join(subtitle_directory, file)
            if os.path.splitext(file_path)[1] in exts:
                subtitle_list.append(file_path)
    else:
        subtitle_list.append(subtitle)

    if xbmcvfs.exists(subtitle_list[0]):
        return subtitle_list






def router(paramstring):
    params = dict(urllib.parse.parse_qsl(paramstring))
    print("Received Parameters:", params)

    if 'action' in params:
        if params['action'] == 'manualsearch':
            if 'searchstring' in params and 'languages' in params and 'preferredlanguage' in params:
                manual_search(params['searchstring'], params['languages'], params['preferredlanguage'])
            else:
                print("Incomplete parameters for manual search.")
        elif params['action'] == 'search' and 'title' in params:
            list_subtitles(params['title'])
        else:
            print("Invalid action")
    else:
        print("No action parameter provided")

if __name__ == '__main__':
    router(sys.argv[2][1:])
